
IF  EXISTS (SELECT * FROM SYS.TRIGGERS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[TRG_EST_WMS_SAI_VOLUME_PEND_INCLUI]'))
DROP TRIGGER [DBO].[TRG_EST_WMS_SAI_VOLUME_PEND_INCLUI]
GO

CREATE TRIGGER [dbo].[TRG_EST_WMS_SAI_VOLUME_PEND_INCLUI] ON [dbo].[EST_WMS_SAI_VOLUME] FOR INSERT AS
	BEGIN
		INSERT INTO EST_WMS_SAI_VOLUME_PEND
		SELECT i.CD_PED_WMS, i.NR_VOLUME, GETDATE()
		FROM INSERTED i
		WHERE NOT EXISTS (SELECT CD_PED_WMS 
						  FROM EST_WMS_SAI_VOLUME_PEND p
						  WHERE p.CD_PED_WMS = i.CD_PED_WMS
								AND p.NR_VOLUME = i.NR_VOLUME)		
	END

